<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $data = Validator::make($request->all(), [
            "email"     => ["required", "string"],
            "password"  => ["required", "string"]
        ])->validate();
        if (!Auth::attempt($data)) {
            return back()->withInput()->with("error", "These credentials do not match our records.");
        };
        return redirect()->intended(RouteServiceProvider::HOME);
    }
    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        return redirect()->route("login");
    }
}
