<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            "country_id"        => 1,
            "name"              => 'super admin',
            "email"             => 'admin@duma-expo.hkl',
            "telephone"         => '7900001',
            "address"           => '157 Chaussee Prince Louis Rwagasore, Bujumbura',
            "email_verified_at" => now(),
            "status"            => 'active',
            "password"          => Hash::make("12345"),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}
