<div class="modal fade" id="add-user" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog modal-xl add-new-user">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="user-title">Add New user</h3>
								</div>
								<form action="{{ route('user.store') }}" method="POST" class="row g-3">
										@csrf
										<div class="col-md-6 border-end border-dark">
												<div class="row">
														<div class="col-12 mb-3">
																<label class="form-label" for="name">Full name</label>
																<input type="text" id="name" name="name"
																		class="form-control @error('name') is-invalid @enderror" placeholder="Full name"
																		value="{{ old('name') }}" />
																@error('name')
																		<div class=" invalid-feedback">{{ $errors->first('name') }}</div>
																@enderror
														</div>
														<div class="col-12 mb-3">
																<label class="form-label" for="email">Email</label>
																<input type="text" id="email" name="email"
																		class="form-control @error('email') is-invalid @enderror" placeholder="Email"
																		value="{{ old('email') }}" />
																@error('email')
																		<div class=" invalid-feedback">{{ $errors->first('email') }}</div>
																@enderror
														</div>
														<div class="col-12 mb-3">
																<label class="form-label" for="telephone">Telephone</label>
																<input type="text" id="telephone" name="telephone"
																		class="form-control @error('telephone') is-invalid @enderror" placeholder="Telephone"
																		value="{{ old('telephone') }}" />
																@error('telephone')
																		<div class="invalid-feedback">{{ $errors->first('telephone') }}</div>
																@enderror
														</div>
														<div class="col-12 mb-3">
																<label class="form-label" for="status">Reseller group</label>
																<select name="reseller_id" class="form-control @error('reseller_id') is-invalid @enderror">
																		<option value="">Select reseller</option>
																		@foreach ($resellers as $resl)
																				<option value="{{ $resl->id }}" @selected((int) old('reseller_id') === $resl->id)>
																						{{ Str::ucfirst($resl->name) }}
																				</option>
																		@endforeach
																</select>
																@error('reseller_id')
																		<div class="invalid-feedback">{{ $errors->first('reseller_id') }}</div>
																@enderror
														</div>
														<div class="col-12 mb-3">
																<label class="form-label" for="status">Country</label>
																<select name="country_id" class="form-control @error('country_id') is-invalid @enderror">
																		<option value="">Select country</option>
																		@foreach ($country as $cont)
																				<option value="{{ $cont->id }}" @selected((int) old('country_id') === $cont->id)>
																						{{ Str::ucfirst($cont->name) }}&nbsp;({{ Str::upper($cont->code) }})
																				</option>
																		@endforeach
																</select>
																@error('country_id')
																		<div class="invalid-feedback">{{ $errors->first('country_id') }}</div>
																@enderror
														</div>
														<div class="col-12 mb-3">
																<label class="form-label" for="password">Password</label>
																<input type="password" id="password" name="password"
																		class="form-control @error('password') is-invalid @enderror" placeholder="Enter a user password" />
																@error('password')
																		<div class=" invalid-feedback">{{ $errors->first('password') }}</div>
																@enderror
														</div>
												</div>
										</div>
										<div class="col-md-6">
												<div class="row">
														<div class="col-12 mb-3">
																<label class="form-label" for="address_1">Address 1</label>
																<input type="text" id="address_1" name="address_1"
																		class="form-control @error('address_1') is-invalid @enderror" placeholder="Address 1"
																		value="{{ old('address_1') }}" />
																@error('address_1')
																		<div class="invalid-feedback">{{ $errors->first('address_1') }}</div>
																@enderror
														</div>

														<div class="col-12 mb-3">
																<label class="form-label" for="address_2">Address 2</label>
																<input type="text" id="address_2" name="address_2"
																		class="form-control @error('address_2') is-invalid @enderror" placeholder="Address 2"
																		value="{{ old('address_2') }}" />
																@error('address_2')
																		<div class="invalid-feedback">{{ $errors->first('address_2') }}</div>
																@enderror
														</div>

														<div class="col-12 mb-3">
																<label class="form-label" for="state">State</label>
																<input type="text" id="state" name="state"
																		class="form-control @error('state') is-invalid @enderror" placeholder="State"
																		value="{{ old('state') }}" />
																@error('state')
																		<div class="invalid-feedback">{{ $errors->first('state') }}</div>
																@enderror
														</div>

														<div class="col-12 mb-3">
																<label class="form-label" for="city">City</label>
																<input type="text" id="city" name="city"
																		class="form-control @error('city') is-invalid @enderror" placeholder="City"
																		value="{{ old('city') }}" />
																@error('city')
																		<div class="invalid-feedback">{{ $errors->first('city') }}</div>
																@enderror
														</div>

														<div class="col-12 mb-3">
																<label class="form-label" for="street">Street</label>
																<input type="text" id="street" name="street"
																		class="form-control @error('street') is-invalid @enderror" placeholder="Street"
																		value="{{ old('street') }}" />
																@error('street')
																		<div class="invalid-feedback">{{ $errors->first('street') }}</div>
																@enderror
														</div>

														<div class="col-12 mb-3">
																<label class="form-label" for="post_code">Post code</label>
																<input type="text" id="post_code" name="post_code"
																		class="form-control @error('post_code') is-invalid @enderror" placeholder="Post code"
																		value="{{ old('post_code') }}" />
																@error('post_code')
																		<div class="invalid-feedback">{{ $errors->first('post_code') }}</div>
																@enderror
														</div>
												</div>
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Save</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
