<?php

namespace App\classes\service;

use App\Models\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator as ValidatorReturn;

class CountryService
{
  public function Index(Request $request)
  {
    $countrys =  Country::paginate(15);
    return $countrys;
  }
  public function Create(Request $request)
  {
    $name = trim(strtolower(htmlspecialchars($request->name)));
    $code = trim(strtolower(htmlspecialchars($request->code)));
    return Country::create(["name" => $name, "code" => $code]);
  }
  public function Update(Request $request, Country $country): Country
  {
    $name = trim(strtolower(htmlspecialchars($request->name)));
    $code = trim(strtolower(htmlspecialchars($request->code)));
    $country->update(["name" => $name, "code" => $code]);
    return $country;
  }

  public function Delete(Country $country): bool
  {
    return $country->delete();
  }
  /**
   * Validation
   *
   * @param  Request $request
   * @param  string $method
   * @param  Country|bool $country
   * @return ValidatorReturn|null
   */
  public function DataValidation(Request $request, String $method, Country|bool $country = null): ValidatorReturn|null
  {
    switch (strtolower($method)) {
      case 'post':
        return Validator::make($request->all(), [
          "name" => ["required", "unique:countries,name"],
          "code" => ["required", "unique:countries,code"]
        ]);
      case 'patch':
        return Validator::make($request->all(), [
          "name" => ["required", Rule::unique("countries", "name")->ignore($country->id)],
          "code" => ["required", Rule::unique("countries", "code")->ignore($country->id)]
        ]);
      default:
        return null;
    }
  }
}
