<?php

namespace App\Http\Controllers\Website;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\classes\service\CountryService;
use App\Models\Country;
use App\Models\Parcel;
use App\Models\ParcelCategory;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class WebsiteController extends Controller
{

  private CountryService $countryService;

  public function __construct()
  {
    $this->countryService = new CountryService();
  }
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    $countries = Country::all();
    return view("website.home.index", compact("countries"));
  }
  /**
   * Display a listing of the resource.
   */
  // public function index()
  // {
  //     //
  //     return view('website.index');
  // }
  /**
   * Show the form for creating a new resource.
   */
  public function check(Request $request)
  {
    $valid = [
      "from_country"  => ["required", "exists:countries,code"],
      "to_country"    => ["required", "exists:countries,code"],
      "weight"        => ["required", "numeric", "min:0", "max:70"],
      "length"        => ["required", "numeric", "min:0", "max:120"],
      "height"        => ["required", "numeric", "min:0", "max:80"],
      "width"         => ["required", "numeric", "min:0", "max:80"],
    ];
    $messages = [
      "weight.max"  => "Maximum weight is 70kg",
      "length.max"  => "Maximum length is 120cm",
      "height.max"  => "Maximum height is 80cm",
      "width.max"   => "Maximum width is 80cm",
    ];
    $data = Validator::make($request->all(), $valid, $messages)->validated();

    $from   = trim(htmlentities(strtolower($request->from_country)));
    $to     = trim(htmlentities(strtolower($request->to_country)));
    $weight = (float)trim(htmlentities($request->weight));
    $length = (float)trim(htmlentities($request->length));
    $height = (float)trim(htmlentities($request->height));
    $width  = (float)trim(htmlentities($request->width));
    // dd($request->all());
    $query = ParcelCategory::query();
    $query->where("weight_min", "<=", $weight)->where("weight_max", ">=", $weight);
    $category = $query->with("parcel_prices")->first();

    $countries = Country::all();
    return view("website.home.search", compact("countries", "category", "data"));
  }


  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    //
  }

  /**
   * Display the specified resource.
   */
  public function show(string $id)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(string $id)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, string $id)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(string $id)
  {
    //
  }
}
