<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parcel_prices', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("parcel_category_id");
            $table->string("reseller")->nullable();
            $table->string("country_from");
            $table->string("country_to");
            $table->double("price_standard");
            $table->double("price_express");
            $table->string("note")->nullable();
            $table->timestamps();

            $table->foreign("parcel_category_id")->references("id")->on("parcel_categories")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("reseller")->references("name")->on("resellers")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("country_from")->references("code")->on("countries")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("country_to")->references("code")->on("countries")->cascadeOnUpdate()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parcel_prices');
    }
};
