<div class="modal fade" id="edit-country-{{ $country->id }}" aria-hidden="true">
		<div class="modal-dialog add-new-country">
				<div class="modal-content p-3 p-md-5">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="country-title">Edit country - {{ Str::ucfirst($country->name) }}</h3>
								</div>
								<form action="{{ route('country.update', ['country' => $country]) }}" method="POST" class="row g-3">
										@csrf
										@method('patch')
										@php
												$err = 'err_' . $country->id;
										@endphp
										<div class="col-12">
												<label class="form-label" for="name">Country name</label>
												<input type="text" id="name" name="name"
														class="form-control @error('name', $err) is-invalid @enderror" placeholder="Enter a country name"
														value="{{ old('name') ?? $country->name }}" />
												@error('name', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('name') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-4">
												<label class="form-label" for="code">Country code</label>
												<input type="text" id="code" name="code"
														class="form-control @error('code', $err) is-invalid @enderror" placeholder="Enter a country code"
														value="{{ old('code') ?? $country->code }}" />
												@error('code', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('code') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
