<div class="modal fade" id="edit-parcel_price-{{ $parcel_price->id }}" aria-hidden="true">
		<div class="modal-dialog add-new-parcel_price">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="parcel_price-title">
												Edit parcel price - {{ Str::upper($parcel_price->country_from . ' => ' . $parcel_price->country_to) }}
										</h3>
								</div>
								<form action="{{ route('parcel-price.update', ['parcel_price' => $parcel_price]) }}" method="POST"
										class="row g-3">
										@csrf
										@method('patch')
										@php
												$err = 'err_' . $parcel_price->id;
										@endphp
										<div class="col-md-12 mb-0">
												<label class="form-label" for="category">Parcel category</label>
												<select class="form-select @error('category', $err) is-invalid @enderror" id="category" name="category">
														<option value="">Select category</option>
														@foreach ($parcelCats as $cats)
																<option value="{{ $cats->id }}" @selected((int) old('category') === $cats->id) @selected($parcel_price->parcel_category_id === $cats->id)>
																		{{ Str::ucfirst($cats->name) }}
																</option>
														@endforeach
												</select>
												@error('category', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('category') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-0">
												<label class="form-label" for="reseller">Reseller group</label>
												<select class="form-select @error('reseller', $err) is-invalid @enderror" id="reseller" name="reseller">
														<option value="">Select reseller group</option>
														@foreach ($reseller as $rsl)
																<option value="{{ $rsl->name }}" @selected(old('reseller') === $rsl->name) @selected($parcel_price->reseller === $rsl->name)>
																		{{ Str::ucfirst($rsl->name) }}
																</option>
														@endforeach
												</select>
												@error('reseller', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('reseller') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-0">
												<label class="form-label" for="country_from{{ $err }}">Country From</label>
												<select class="select2 form-select  @error('country_from', $err) is-invalid @enderror"
														id="country_from{{ $err }}" name="country_from">
														<option value="">Country From</option>
														@foreach ($country as $from)
																<option value="{{ $from->code }}" @selected(old('country_from') === $from->code) @selected($parcel_price->country_from === $from->code)>
																		{{ Str::ucfirst($from->name) }}
																</option>
														@endforeach
												</select>
												@error('country_from', $err)
														<div class="text-danger">{{ $errors->$err->first('country_from') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-0	">
												<label for="country_to{{ $err }}" class="form-label">Country to export</label>
												<select id="country_to{{ $err }}"
														class="select2 form-select @error('country_to', $err) is-invalid @enderror" name="country_to[]">
														<option value="">Country To</option>
														@foreach ($country as $to)
																<option value="{{ $to->code }}" @selected($to->code === old('country_to')) @selected($parcel_price->country_to === $to->code)>
																		{{ Str::ucfirst($to->name) }}
																</option>
														@endforeach
												</select>
												@error('country_to', $err)
														<div class="text-danger">{{ $errors->$err->first('country_to') }}</div>
												@enderror
										</div>
										<div class="col-md-6 mb-0">
												<label class="form-label" for="standard">Standard price</label>
												<input type="text" id="standard" class="form-control @error('standard', $err) is-invalid @enderror"
														name="standard" placeholder="Standard price"
														value="{{ old('standard') ?? $parcel_price->price_standard }}">
												@error('standard', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('standard') }}</div>
												@enderror
										</div>
										<div class="col-md-6 mb-0">
												<label class="form-label" for="express">Express price</label>
												<input type="text" id="express" class="form-control @error('express', $err) is-invalid @enderror"
														name="express" placeholder="Express price" value="{{ old('express') ?? $parcel_price->price_express }}">
												@error('express', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('express') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-3">
												<label class="form-label" for="note">Note</label>
												<input type="text" id="note" class="form-control @error('note', $err) is-invalid @enderror"
														name="note" placeholder="Note" value="{{ old('note') ?? $parcel_price->note }}">
												@error('note', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('note') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center mt-3">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
