<div class="modal fade" id="edit-status-{{ $stat->id }}" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-status">
				<div class="modal-content p-3 p-md-5">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="status-title">Edit status - {{ Str::ucfirst($stat->name) }}</h3>
								</div>
								<form action="{{ route('status.update', ['status' => $stat]) }}" method="POST" class="row g-3">
										@csrf
										@method('patch')
										@php
												$err = 'err_' . $stat->id;
										@endphp
										<div class="col-md-12">
												<label for="modle" class="form-label">Modules</label>
												<select class="form-select @error('module', $err) is-invalid @enderror" id="modle" name="module">
														<option selected="">Select module</option>
														@foreach ($modules as $id => $name)
																<option value="{{ $name }}" @selected(old('module') === $name) @selected($stat->module === $name)>
																		{{ Str::ucfirst($name) }}
																</option>
														@endforeach
												</select>
												@error('module', $err)
														<div class=" invalid-feedback">{{ $error->$err->first('module') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-4">
												<label class="form-label" for="name">Module name</label>
												<input type="text" id="name" name="name"
														class="form-control @error('name', $err) is-invalid @enderror" placeholder="Enter a status name"
														tabindex="-1" value="{{ old('name') ?? $stat->name }}" />
												@error('name', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('name') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
