@extends('layouts.website.website')
@section('web-style')
		<style>
				.vertical-center {
						min-height: auto !important;
				}
		</style>
@section('content')
		<!-- content begin -->
		<div class="no-bottom no-top" id="content">
				<div id="top"></div>
				<section aria-label="section" class="jarallax vertical-center">
						<img src="{{ asset('website/images/new2.jpg') }}" class="jarallax-img" alt="">
						<div class="container position-relative1 z1000">
								<div class="row align-items-center justify-content-center">
										<div class="col-lg-10">
												<div class="spacer-single sm-hide"></div>
												<div class="p-4 rounded-3 shadow-soft" data-bgcolor="#ffffff">
														<form name="contactForm" id='contact_form' method="get" action="{{ route('check') }}">
																<div class="spacer-20"></div>
																<div class="row">
																		<div class="col-lg-6 mb-3">
																				<h5>From</h5>
																				<select class="form-control @error('from_country') is-invalid @enderror" name="from_country">
																						<option value="">Select a country</option>
																						@foreach ($countries as $item)
																								@if ($item->code === 'uk')
																										<option value="uk" selected @selected(old('from_country') === $item->code) @selected($data['to_country'] === $item->code)>
																												{{ Str::ucfirst($item->name) }}
																										</option>
																								@endif
																						@endforeach
																				</select>
																				@error('from_country')
																						<div class="invalid-feedback">{{ $errors->first('from_country') }}</div>
																				@enderror
																		</div>

																		<div class="col-lg-6 mb-3">
																				<h5>To</h5>
																				<select class="form-control @error('to_country') is-invalid @enderror" name="to_country">
																						<option value="">Select a country</option>
																						@foreach ($countries as $item)
																								@if ($item->code !== 'uk')
																										<option value="{{ $item->code }}" @selected(old('to_country') === $item->code)@selected($data['to_country'] === $item->code)>
																												{{ Str::ucfirst($item->name) }}
																										</option>
																								@endif
																						@endforeach
																				</select>
																				@error('to_country')
																						<div class="invalid-feedback">{{ $errors->first('to_country') }}</div>
																				@enderror
																		</div>

																		<div class="col-lg-3 mb-3">
																				<h5>Weight</h5>
																				<div class="input-group input-group-merge">
																						<input type="number"step="0.001" class="form-control @error('weight') is-invalid @enderror"
																								placeholder="Weight" aria-label="Weight" name="weight"
																								value="{{ old('weight') ?? $data['weight'] }}">
																						<span class="input-group-text" id="basic-addon33">Kg</span>
																						@error('weight')
																								<div class="invalid-feedback">{{ $errors->first('weight') }}</div>
																						@enderror
																				</div>
																		</div>
																		<div class="col-lg-3 mb-3">
																				<h5>Length</h5>
																				<div class="input-group input-group-merge">
																						<input type="number"step="0.001" class="form-control @error('length') is-invalid @enderror"
																								placeholder="Length" aria-label="Length" name="length"
																								value="{{ old('length') ?? $data['length'] }}">
																						<span class="input-group-text" id="basic-addon33">cm</span>

																						@error('length')
																								<div class="invalid-feedback">{{ $errors->first('length') }}</div>
																						@enderror
																				</div>
																		</div>
																		<div class="col-lg-3 mb-3">
																				<h5>Height</h5>
																				<div class="input-group input-group-merge">
																						<input type="number"step="0.001" class="form-control @error('height') is-invalid @enderror"
																								placeholder="Height" aria-label="Height" name="height"
																								value="{{ old('height') ?? $data['height'] }}">
																						<span class="input-group-text" id="basic-addon33">cm</span>

																						@error('height')
																								<div class="invalid-feedback">{{ $errors->first('height') }}</div>
																						@enderror
																				</div>
																		</div>
																		<div class="col-lg-3 mb-3">
																				<h5>Width</h5>
																				<div class="input-group input-group-merge">
																						<input type="number"step="0.001" class="form-control @error('width') is-invalid @enderror"
																								placeholder="Width" aria-label="Width" name="width"
																								value="{{ old('width') ?? $data['width'] }}">
																						<span class="input-group-text" id="basic-addon33">cm</span>

																						@error('width')
																								<div class="invalid-feedback">{{ $errors->first('width') }}</div>
																						@enderror
																				</div>
																		</div>

																		<div class="col-lg-12 my-4">
																				<input type='submit' id='send_message' value='Get a quote' class="btn-main pull-right">
																		</div>
																</div>
														</form>
												</div>
										</div>
								</div>
						</div>
				</section>

				<section id="section-cars">
						<div class="container">
								<div class="row">
										<div class="col-lg-12 mb-3">
												<div class="d-info">
														<div class="d-text mb-4">
																<h2 style="text-align: center;">
																		YOUR RESULTS FOR DELIVERY TO BURUNDI
																</h2>
														</div>
												</div>
												@for ($i = 0; $i < 3; $i++)
														<div class="d-flex border border-primary border-2 rounded-2 py-3 mb-3">
																<div class="col-lg-2 border-end d-flex flex-column align-items-center">
																		<h3 class="mb-3">Box3</h3>
																		<span><b>Size:&nbsp;</b>27 x 35 x 2cm</span>
																		<span><b>Weight:&nbsp;</b>Up to 0.5kg</span>
																</div>
																<div class="col-lg-8 border-end">
																		<table class="table">
																				<thead>
																						<tr>
																								<th class="py-1 font-weight-bolder text-center border-end">Weight</th>
																								<th class="py-1 font-weight-bolder text-center border-end">Length</th>
																								<th class="py-1 font-weight-bolder text-center border-end">Height</th>
																								<th class="py-1 font-weight-bolder text-center ">Width</th>
																						</tr>
																				</thead>
																				<tbody>
																						<tr>
																								<td class="border-bottom-0 text-center border-end">10kg</td>
																								<td class="border-bottom-0 text-center border-end">2cm</td>
																								<td class="border-bottom-0 text-center border-end">5cm</td>
																								<td class="border-bottom-0 text-center ">3cm</td>
																						</tr>
																				</tbody>
																		</table>
																</div>
																<div class="col-lg-2 border-end d-flex flex-column align-items-center">
																		<h3 class="mb-2">Price</h3>
																		<span>4 $</span>
																</div>
														</div>
												@endfor
										</div>
										<div class="col-lg-12">
												<button type="submit" class="btn-main pull-right" id="send_message">Complete parcel details now</button>
										</div>
								</div>
						</div>
				</section>
		</div>
		<!-- content close -->
		<a href="#" id="back-to-top"></a>
@endsection
