<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\ParcelCategory;
use App\Http\Controllers\Controller;
use App\classes\service\ParcelCategoryService;
use App\Models\Country;
use App\Models\Reseller;

class ParcelCategoryController extends Controller
{
    private ParcelCategoryService $parcel_categoryService;

    public function __construct()
    {
        $this->parcel_categoryService = new ParcelCategoryService();
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $parcel_categorys   = $this->parcel_categoryService->Index($request);
        $reseller           = Reseller::all();
        $country            = Country::all();
        return view("admin.parcel_category.index", compact("parcel_categorys", "reseller", "country"));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $this->parcel_categoryService->DataValidation($request, "post");
        if ($data->fails()) {
            return back()->withInput()->withErrors($data);
        }
        $parcel_category = $this->parcel_categoryService->Create($request);
        return redirect()->route("parcel-category.index")->with("success", "ParcelCategory successfully created.");
    }

    /**
     * Display the specified resource.
     */
    public function show(ParcelCategory $parcel_category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ParcelCategory $parcel_category)
    {
        return view("admin.parcel_category.index", compact("parcel_category"));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ParcelCategory $parcel_category)
    {
        $data = $this->parcel_categoryService->DataValidation($request, "patch", $parcel_category);
        if ($data->fails()) {
            return back()->withInput()->withErrors($data, "err_" . $parcel_category->id)->with("err", $parcel_category->id);
        }
        $parcel_category = $this->parcel_categoryService->Update($request, $parcel_category);
        return redirect()->route("parcel-category.index")->with("success", "ParcelCategory ($parcel_category->name) successfully updated.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ParcelCategory $parcel_category)
    {
        $name = $parcel_category->name;
        $this->parcel_categoryService->Delete($parcel_category);
        return redirect()->route("parcel-category.index")->with("success", "ParcelCategory ($parcel_category->name) successfully updated.");
    }
}
