<?php

namespace App\Http\Controllers\Website;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\classes\service\CountryService;
use App\Http\Requests\UserRequest;
use App\Models\Country;
use App\Models\Parcel;
use App\Models\ParcelCategory;
use App\Models\ParcelPrice;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Redirector;
//use App\classes\ParcelCookie;


class WebsiteController extends Controller
{

  private CountryService $countryService;

  public function __construct()
  {
    $this->countryService = new CountryService();
  }

  public function view_collection()
  {
    return view('website.dashboard');
  }

  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    $countries = Country::all()->sortBy("name");
    $default_country = Country::where('name', 'United Kingdom')->get();
    if (session()->has('from')) {
      $request->session()->flush();
    }
    return view("website.home.index", compact("countries", 'default_country'));
  }
  /**
   * Display a listing of the resource.
   */
  public function book_collection(Request $request)
  {
    //
    //dd($request);
    $valid = [
      "receiver_country"          => ["required", "exists:countries,code"],
      "receiver_phone"            => ["required", "numeric", "min:10"],
      "receiver_name"             => ["required"],
      "receiver_company_name"     => ["required"],
      "receiver_confirm_email"    => ["required", "email"],
      "receiver_email"            => ["required", "email"],
      "receiver_country"          => ["required"],
      "receiver_type"             => ["required"],
      "sender_country"            => ["required", "exists:countries,name"],
      "sender_phone"              => ["required", "numeric", "min:10"],
      "sender_town"               => ["required"],
      "sender_type"               => ["required"],
      "sender_county"             => ["required"],
      "sender_password"           => ["required"],
      "sender_address"            => ["required"],
      "sender_company"            => ["required"],
      "sender_post_code"          => ["required"],
      "sender_email"              => ["required", "email"]
    ];
    $messages = [
      "weight.max"  => "Maximum weight is 70kg",
      "length.max"  => "Maximum length is 120cm",
      "height.max"  => "Maximum height is 80cm",
      "width.max"   => "Maximum width is 80cm",
    ];
    $data = Validator::make($request->all(), $valid, $messages)->validated();


    $sender_type = trim(htmlentities($request->input('sender_type')));
    $sender_country  = trim(htmlentities(strtolower($request->sender_country)));
    $sender_name = trim(htmlentities($request->sender_name));
    $sender_email = trim(htmlentities($request->sender_email));
    $sender_address = trim(htmlentities($request->sender_address));
    $sender_company = trim(htmlentities($request->sender_company));
    $sender_town = trim(htmlentities($request->sender_town));
    $sender_post_code  = trim(htmlentities($request->sender_post_code));
    $sender_phone  = trim(htmlentities($request->sender_phone));

    $receiver_country = $request->input('receiver_country');
    $receiver_name    = $request->input('receiver_name');
    $receiver_phone   = $request->input('receiver_phone');
    $receiver_email   = $request->input('receiver_email');
    //    $sender_password = trim(htmlentities($request->sender_password));

    $receiver_country = Country::where('id', $receiver_country)->first();
    //dd($country);

    $request->session()->put('receiver_name', $receiver_name);
    $request->session()->put('receiver_country', $receiver_country['name']);
    $request->session()->put('receiver_email', $receiver_email);
    $request->session()->put('receiver_phone', $receiver_phone);
    // $request->session()->put('receiver_address', $receiver_address);


    $country = Country::where('name', $sender_country)->get();
    //dd($country);

    foreach ($country as $item) {
      $user = new User;
      $user->name = $sender_name;
      $user->email = $sender_email;
      $user->address = $sender_address . ' ' . $sender_town . ' ' . $sender_town . ' ' . $sender_post_code;
      $user->telephone = $sender_phone;
      //$user->sender_type= $sender_type;
      $user->status = 'active';
      //$user->password = $sender_password;
      $user->country_id = $item->id;
    }
    //$user->save();;

    if (Auth::check()) {
      return redirect()->route('confirmation');
    } else {
      return redirect()->route('sign-in');
    }
  }
  /**
   * Show the form for creating a new resource.
   */
  public function check(Request $request)
  {
    $valid = [
      "from_country"  => ["required", "exists:countries,code"],
      "to_country"    => ["required", "exists:countries,code"],
      "weight"        => ["required", "numeric", "min:0", "max:70"],
      "length"        => ["required", "numeric", "min:0", "max:120"],
      "height"        => ["required", "numeric", "min:0", "max:80"],
      "width"         => ["required", "numeric", "min:0", "max:80"],
    ];
    $messages = [
      "weight.max"  => "Maximum weight is 70kg",
      "length.max"  => "Maximum length is 120cm",
      "height.max"  => "Maximum height is 80cm",
      "width.max"   => "Maximum width is 80cm",
    ];
    $data = Validator::make($request->all(), $valid, $messages)->validated();

    $from   = trim(htmlentities(strtolower($request->from_country)));
    $to     = trim(htmlentities(strtolower($request->to_country)));
    $weight = (float)trim(htmlentities($request->weight));
    $length = (float)trim(htmlentities($request->length));
    $height = (float)trim(htmlentities($request->height));
    $width  = (float)trim(htmlentities($request->width));

    $request->session()->put('from', $from);
    $request->session()->put('to', $to);
    $request->session()->put('weight', $weight);
    $request->session()->put('height', $height);
    $request->session()->put('width', $width);


    $query = ParcelCategory::query();
    $query->where("weight_min", "<=", $weight)->where("weight_max", ">=", $weight);
    $category = $query->with("parcel_prices")->first();

    //dd($category);

    $query1 = ParcelPrice::query();
    $query1->where("parcel_category_id", $category->id)->where('country_from', $data['from_country'])->where('country_to', $data['to_country']);
    $parcel_price = $query1->first();

    $request->session()->put('parcel_price', $parcel_price->price_standard);
    $request->session()->put('parcel_category_id', $category->id);

    $countries = Country::all()->sortBy("name");


    return view("website.home.search", compact("countries", "category", "data", "parcel_price"));
  }

  public function check_price(Request $request)
  {
    $valid = [
      "from_country"  => ["required", "exists:countries,code"],
      "to_country"    => ["required", "exists:countries,code"],
      "weight"        => ["required", "numeric", "min:0", "max:70"],
      "length"        => ["required", "numeric", "min:0", "max:120"],
      "height"        => ["required", "numeric", "min:0", "max:80"],
      "width"         => ["required", "numeric", "min:0", "max:80"],
    ];
    $messages = [
      "weight.max"  => "Maximum weight is 70kg",
      "length.max"  => "Maximum length is 120cm",
      "height.max"  => "Maximum height is 80cm",
      "width.max"   => "Maximum width is 80cm",
    ];
    $data = Validator::make($request->all(), $valid, $messages)->validated();

    $from   = trim(htmlentities(strtolower($request->from_country)));
    $to     = trim(htmlentities(strtolower($request->to_country)));
    $weight = (float)trim(htmlentities($request->weight));
    $length = (float)trim(htmlentities($request->length));
    $height = (float)trim(htmlentities($request->height));
    $width  = (float)trim(htmlentities($request->width));

    $request->session()->put('from', $from);
    $request->session()->put('to', $to);
    $request->session()->put('weight', $weight);
    $request->session()->put('height', $height);
    $request->session()->put('width', $width);


    $query = ParcelCategory::query();
    $query->where("weight_min", "<=", $weight)->where("weight_max", ">=", $weight);
    $category = $query->with("parcel_prices")->first();

    //dd($category);

    $query1 = ParcelPrice::query();
    $query1->where("parcel_category_id", $category->id)->where('country_from', $data['from_country'])->where('country_to', $data['to_country']);
    $parcel_price = $query1->first();

    $request->session()->put('parcel_price', $parcel_price->price_standard);
    $request->session()->put('parcel_category_id', $category->id);

    $countries = Country::all()->sortBy("name");

    return response()->json(['success' => true,'parcel_price'=> $parcel_price]);
  }


    //return view("website.home.search", compact("countries", "category", "data", "parcel_price"));
  //}

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
    return view('website.sign-in');
  }

  /**
   * Undocumented function
   *
   * @return void
   */
  public function quote()
  {
    //
    return view('website.quote');
  }

  /**
   * Undocumented function
   *
   * @return void
   */
  public function confirmation()
  {
    return view('website.confirmation');
  }

  /**
   * Undocumented function
   *
   * @return void
   */
  public function dashboard()
  {
    return view('website.dashboard');
  }



  /**
   * Show the form for creating a new resource.
   */
  public function register()
  {
    //
    $default_country = Country::where('name', 'United Kingdom')->get();
    return view('website.register', compact('default_country'));
  }
  /**
   * Store a newly created resource in storage.
   */
  public function store(UserRequest $request)
  {
    //
    $user = $request->validated();
    $user["password"] = Hash::make($request->get("password"));
    $user['status'] = 'active';
    $find = User::create($user);

    return view('website.dashboard', compact('find'));
  }

  public function service_point()
  {
    $default_country = Country::where('name', 'United Kingdom')->get();

    $countries = Country::all()->sortBy("name");
    return view('website.service-point', compact('countries', 'default_country'));
  }


  public function authenticate(Request $request)
  {
    //dd($request);
    $user = User::where('email', $request->email)->first();
    //if (!$user || !Hash::check($request->password, $user->password)) {
    if (!Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
      return back()->with('error', "These credentials do not match our records");
    } elseif (session()->has('from')) {
      # code...
      return redirect()->route('confirmation')->with('user', $user);
    } else {
      # code...
      return redirect()->route('dashboard')->with('user', $user);
    }
  }

  /**
   * Display the specified resource.
   */
  public function show(string $id)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(string $id)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, string $id)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(string $id)
  {
    //
  }

  public function logout(Request $request)
  {
    Auth::guard('web')->logout();

    $request->session()->invalidate();

    $request->session()->regenerateToken();

    return redirect()->route('sign-in');
    //return redirect('/register');
  }
}
