<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            //
            //'firstname' => 'required |string |max:255',
            'name' => 'required | string |max: 255',
            'address' => 'required | max: 255',
            //'address1' => 'required | max: 255',
            'country_id' => 'required',
            'telephone' => 'required | max: 255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:8|string|confirmed',
        ];
    }
}
