-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Hôte : localhost:3306
-- Généré le : sam. 16 sep. 2023 à 22:55
-- Version du serveur : 8.0.30
-- Version de PHP : 8.1.10

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `duma_expo`
--

-- --------------------------------------------------------

--
-- Structure de la table `countries`
--

CREATE TABLE `countries` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `countries`
--

INSERT INTO `countries` (`id`, `name`, `code`, `created_at`, `updated_at`) VALUES
(1, 'Burundi', 'BI', '2023-08-10 06:06:39', '2023-08-10 06:06:39'),
(2, 'rwanda', 'rwd', '2023-08-22 07:20:59', '2023-08-22 07:20:59'),
(3, 'united kingdom', 'uk', '2023-08-22 07:21:17', '2023-08-22 07:21:17'),
(4, 'kenya', 'ke', '2023-08-22 07:21:28', '2023-08-22 07:21:28'),
(5, 'tanzanie', 'tz', '2023-08-22 07:21:41', '2023-08-22 07:21:41');

-- --------------------------------------------------------

--
-- Structure de la table `currencies`
--

CREATE TABLE `currencies` (
  `id` bigint UNSIGNED NOT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `currencies`
--

INSERT INTO `currencies` (`id`, `country_id`, `name`, `code`, `created_at`, `updated_at`) VALUES
(1, 3, 'livre sterling', 'gbp', NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `details`
--

CREATE TABLE `details` (
  `id` bigint UNSIGNED NOT NULL,
  `order_id` bigint UNSIGNED NOT NULL,
  `parcel_id` bigint UNSIGNED NOT NULL,
  `receiver_id` bigint UNSIGNED NOT NULL,
  `price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `migrations`
--

CREATE TABLE `migrations` (
  `id` int UNSIGNED NOT NULL,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_11_000001_create_modules_table', 1),
(2, '2014_10_11_000002_create_statuses_table', 1),
(3, '2014_10_11_000003_create_countries_table', 1),
(4, '2014_10_11_000004_create_resellers_table', 1),
(5, '2014_10_12_000000_create_users_table', 1),
(6, '2014_10_12_100000_create_password_reset_tokens_table', 1),
(7, '2019_08_19_000000_create_failed_jobs_table', 1),
(8, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(9, '2023_07_18_081940_create_permission_tables', 1),
(10, '2023_07_18_082525_create_user_addresses_table', 1),
(11, '2023_07_18_135339_create_payment_methods_table', 1),
(12, '2023_07_18_135433_create_user_payment_method_table', 1),
(13, '2023_08_09_122520_create_parcel_categories_table', 1),
(15, '2023_08_09_122536_create_currencies_table', 1),
(16, '2023_08_09_122545_create_parcels_table', 1),
(17, '2023_08_09_122546_create_receiver_details_table', 1),
(18, '2023_08_09_122547_create_orders_table', 1),
(19, '2023_08_09_122548_create_details_table', 1),
(20, '2023_08_09_122521_create_parcel_prices_table', 2),
(21, '2014_10_10_000002_create_setting_systems_table', 3);

-- --------------------------------------------------------

--
-- Structure de la table `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint UNSIGNED NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint UNSIGNED NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(2, 'App\\Models\\User', 3);

-- --------------------------------------------------------

--
-- Structure de la table `modules`
--

CREATE TABLE `modules` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `modules`
--

INSERT INTO `modules` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, 'user', '2023-08-10 06:06:39', '2023-08-10 06:06:39'),
(2, 'role', '2023-08-11 05:01:06', '2023-08-11 05:01:10'),
(3, 'reseller', '2023-08-11 05:01:15', '2023-08-11 05:01:15');

-- --------------------------------------------------------

--
-- Structure de la table `orders`
--

CREATE TABLE `orders` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `qty` int NOT NULL,
  `sub_total` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxe` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `total` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_method` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_date` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `parcels`
--

CREATE TABLE `parcels` (
  `id` bigint UNSIGNED NOT NULL,
  `parcel_category_id` bigint UNSIGNED NOT NULL,
  `country_from` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_to` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `length` double NOT NULL,
  `height` double NOT NULL,
  `width` double NOT NULL,
  `weight` double NOT NULL,
  `price` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `parcel_categories`
--

CREATE TABLE `parcel_categories` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `length_min` double NOT NULL,
  `length_max` double NOT NULL,
  `height_min` double NOT NULL,
  `height_max` double NOT NULL,
  `width_min` double NOT NULL,
  `width_max` double NOT NULL,
  `weight_min` double NOT NULL,
  `weight_max` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `parcel_categories`
--

INSERT INTO `parcel_categories` (`id`, `name`, `length_min`, `length_max`, `height_min`, `height_max`, `width_min`, `width_max`, `weight_min`, `weight_max`, `created_at`, `updated_at`) VALUES
(1, 'enveloppe', 27, 34, 35, 18, 2, 10, 0, 0.5, '2023-08-22 11:15:02', '2023-08-30 05:30:17'),
(4, 'box2', 34, 34, 18, 32, 10, 10, 0.5, 1.5, '2023-08-29 05:03:41', '2023-08-30 05:31:03'),
(5, 'box3', 34, 34, 32, 32, 10, 18, 1.5, 3, '2023-08-29 05:04:09', '2023-08-30 05:31:28'),
(6, 'box4', 34, 34, 32, 32, 18, 24, 3, 7, '2023-08-29 05:04:30', '2023-08-30 05:31:41'),
(7, 'box5', 34, 42, 32, 36, 24, 37, 7, 12, '2023-08-29 05:06:01', '2023-08-30 05:32:07'),
(8, 'box6', 42, 48, 36, 40, 37, 39, 12, 18, '2023-08-29 05:06:26', '2023-08-30 05:34:58'),
(9, 'box7', 48, 54, 40, 44, 39, 41, 18, 25, '2023-08-29 05:06:48', '2023-08-30 05:32:22'),
(10, 'box8', 54, 60, 44, 48, 41, 43, 25, 32, '2023-08-29 05:07:52', '2023-08-30 05:34:45'),
(11, 'box9', 60, 66, 48, 52, 43, 45, 32, 42, '2023-08-29 05:08:38', '2023-08-30 05:34:31'),
(12, 'box10', 66, 72, 52, 56, 45, 47, 42, 52, '2023-08-29 05:09:24', '2023-08-30 05:34:01'),
(13, 'box11', 72, 78, 56, 56, 47, 48, 52, 63, '2023-08-29 05:09:43', '2023-08-30 05:33:43'),
(14, 'box12', 78, 0, 56, 0, 48, 0, 62, 70, '2023-08-29 05:09:59', '2023-08-29 05:09:59');

-- --------------------------------------------------------

--
-- Structure de la table `parcel_prices`
--

CREATE TABLE `parcel_prices` (
  `id` bigint UNSIGNED NOT NULL,
  `parcel_category_id` bigint UNSIGNED NOT NULL,
  `reseller` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_from` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_to` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price_standard` double NOT NULL,
  `price_express` double NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `parcel_prices`
--

INSERT INTO `parcel_prices` (`id`, `parcel_category_id`, `reseller`, `country_from`, `country_to`, `price_standard`, `price_express`, `note`, `created_at`, `updated_at`) VALUES
(11, 1, NULL, 'uk', 'BI', 29.88, 29.88, NULL, '2023-08-29 05:14:58', '2023-08-29 05:14:58'),
(12, 1, NULL, 'uk', 'rwd', 29.88, 29.88, NULL, '2023-08-29 05:14:58', '2023-08-29 05:14:58'),
(13, 1, NULL, 'uk', 'ke', 29.88, 29.88, NULL, '2023-08-29 05:14:58', '2023-08-29 05:14:58'),
(14, 1, NULL, 'uk', 'tz', 29.88, 29.88, NULL, '2023-08-29 05:14:58', '2023-08-29 05:14:58'),
(15, 4, NULL, 'uk', 'BI', 40.78, 40.78, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(16, 4, NULL, 'uk', 'rwd', 40.78, 40.78, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(17, 4, NULL, 'uk', 'ke', 40.78, 40.78, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(18, 4, NULL, 'uk', 'tz', 40.78, 40.78, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(19, 5, NULL, 'uk', 'BI', 49.84, 49.84, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(20, 5, NULL, 'uk', 'rwd', 49.84, 49.84, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(21, 5, NULL, 'uk', 'ke', 49.84, 49.84, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(22, 5, NULL, 'uk', 'tz', 49.84, 49.84, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(23, 6, NULL, 'uk', 'BI', 70.8, 70.8, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(24, 6, NULL, 'uk', 'rwd', 70.8, 70.8, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(25, 6, NULL, 'uk', 'ke', 70.8, 70.8, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(26, 6, NULL, 'uk', 'tz', 70.8, 70.8, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(27, 7, NULL, 'uk', 'BI', 106.58, 106.58, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(28, 7, NULL, 'uk', 'rwd', 106.58, 106.58, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(29, 7, NULL, 'uk', 'ke', 106.58, 106.58, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(30, 7, NULL, 'uk', 'tz', 106.58, 106.58, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(31, 8, NULL, 'uk', 'BI', 139.66, 139.66, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(32, 8, NULL, 'uk', 'rwd', 139.66, 139.66, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(33, 8, NULL, 'uk', 'ke', 139.66, 139.66, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(34, 8, NULL, 'uk', 'tz', 139.66, 139.66, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(35, 9, NULL, 'uk', 'BI', 173.02, 173.02, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(36, 9, NULL, 'uk', 'rwd', 173.02, 173.02, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(37, 9, NULL, 'uk', 'ke', 173.02, 173.02, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(38, 9, NULL, 'uk', 'tz', 173.02, 173.02, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(39, 10, NULL, 'uk', 'BI', 234.9, 234.9, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(40, 10, NULL, 'uk', 'rwd', 234.9, 234.9, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(41, 10, NULL, 'uk', 'ke', 234.9, 234.9, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(42, 10, NULL, 'uk', 'tz', 234.9, 234.9, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(43, 11, NULL, 'uk', 'BI', 349.3, 349.3, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(44, 11, NULL, 'uk', 'rwd', 349.3, 349.3, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(45, 11, NULL, 'uk', 'ke', 349.3, 349.3, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(46, 11, NULL, 'uk', 'tz', 349.3, 349.3, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(47, 12, NULL, 'uk', 'BI', 463.7, 463.7, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(48, 12, NULL, 'uk', 'rwd', 463.7, 463.7, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(49, 12, NULL, 'uk', 'ke', 463.7, 463.7, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(50, 12, NULL, 'uk', 'tz', 463.7, 463.7, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(51, 13, NULL, 'uk', 'BI', 584.54, 584.54, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(52, 13, NULL, 'uk', 'rwd', 584.54, 584.54, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(53, 13, NULL, 'uk', 'ke', 584.54, 584.54, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(54, 13, NULL, 'uk', 'tz', 584.54, 584.54, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(55, 14, NULL, 'uk', 'BI', 629.62, 629.62, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(56, 14, NULL, 'uk', 'rwd', 629.62, 629.62, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(57, 14, NULL, 'uk', 'ke', 629.62, 629.62, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58'),
(58, 14, NULL, 'uk', 'tz', 629.62, 629.62, NULL, '2023-08-29 02:14:58', '2023-08-29 02:14:58');

-- --------------------------------------------------------

--
-- Structure de la table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `payment_methods`
--

CREATE TABLE `payment_methods` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'manage user', 'web', '2023-08-11 05:01:58', '2023-08-11 05:01:58'),
(2, 'create user', 'web', '2023-08-11 05:01:58', '2023-08-11 05:01:58'),
(3, 'update user', 'web', '2023-08-11 05:01:58', '2023-08-11 05:01:58'),
(4, 'delete user', 'web', '2023-08-11 05:01:58', '2023-08-11 05:01:58'),
(5, 'manage role', 'web', '2023-08-11 05:02:04', '2023-08-11 05:02:04'),
(6, 'create role', 'web', '2023-08-11 05:02:04', '2023-08-11 05:02:04'),
(7, 'update role', 'web', '2023-08-11 05:02:04', '2023-08-11 05:02:04'),
(8, 'delete role', 'web', '2023-08-11 05:02:04', '2023-08-11 05:02:04'),
(9, 'manage reseller', 'web', '2023-08-11 05:02:09', '2023-08-11 05:02:09'),
(10, 'create reseller', 'web', '2023-08-11 05:02:09', '2023-08-11 05:02:09'),
(11, 'update reseller', 'web', '2023-08-11 05:02:09', '2023-08-11 05:02:09'),
(12, 'delete reseller', 'web', '2023-08-11 05:02:09', '2023-08-11 05:02:09');

-- --------------------------------------------------------

--
-- Structure de la table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `receiver_details`
--

CREATE TABLE `receiver_details` (
  `id` bigint UNSIGNED NOT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `post_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `resellers`
--

CREATE TABLE `resellers` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `resellers`
--

INSERT INTO `resellers` (`id`, `name`, `created_at`, `updated_at`) VALUES
(2, 'sliver', '2023-08-10 06:12:54', '2023-08-11 05:02:35'),
(3, 'gold', '2023-08-10 06:13:03', '2023-08-11 05:03:09'),
(4, 'premium', '2023-08-11 05:02:48', '2023-08-11 05:03:03');

-- --------------------------------------------------------

--
-- Structure de la table `roles`
--

CREATE TABLE `roles` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'super admin', 'web', '2023-08-11 05:03:49', '2023-08-11 05:03:49'),
(2, 'user', 'web', '2023-08-11 05:03:59', '2023-08-11 05:03:59'),
(3, 'admin', 'web', '2023-08-11 05:04:15', '2023-08-11 05:04:15');

-- --------------------------------------------------------

--
-- Structure de la table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint UNSIGNED NOT NULL,
  `role_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(1, 2),
(2, 2),
(3, 2),
(4, 2),
(1, 3),
(2, 3),
(3, 3),
(5, 3),
(6, 3),
(7, 3),
(9, 3),
(10, 3),
(11, 3);

-- --------------------------------------------------------

--
-- Structure de la table `setting_systems`
--

CREATE TABLE `setting_systems` (
  `id` bigint UNSIGNED NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_order` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `setting_systems`
--

INSERT INTO `setting_systems` (`id`, `key`, `value`, `type`, `display_order`, `created_at`, `updated_at`) VALUES
(4, 'currency', 'gbp', 'text', 1, '2023-08-29 04:39:41', '2023-08-29 05:59:04');

-- --------------------------------------------------------

--
-- Structure de la table `statuses`
--

CREATE TABLE `statuses` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `statuses`
--

INSERT INTO `statuses` (`id`, `name`, `module`, `created_at`, `updated_at`) VALUES
(1, 'active', 'user', '2023-08-10 06:06:39', '2023-08-10 06:06:39'),
(2, 'pending', 'user', '2023-08-11 05:01:38', '2023-08-11 05:01:38'),
(3, 'suspended', 'user', '2023-08-11 05:01:46', '2023-08-11 05:01:46');

-- --------------------------------------------------------

--
-- Structure de la table `users`
--

CREATE TABLE `users` (
  `id` bigint UNSIGNED NOT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `reseller` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `users`
--

INSERT INTO `users` (`id`, `country_id`, `reseller`, `name`, `email`, `telephone`, `address`, `email_verified_at`, `status`, `password`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 1, NULL, 'super admin', 'admin@duma-expo.hkl', '7900001', '157 Chaussee Prince Louis Rwagasore, Bujumbura', '2023-08-10 06:06:39', 'active', '$2y$10$M5G/Tt5T.IMHxtH48AWc2.RwVf65v7gJKsiJedsxA9raxXT03kXq.', NULL, '2023-08-10 06:06:39', '2023-08-10 06:06:39'),
(3, 1, 'gold', 'Ila Gardner', 'dofoxerih@mailinator.com', '+1 (382) 322-7446', '45 East Fabien Lane', NULL, 'active', '$2y$10$4QH6C81kct3lHOeMsjGzQeRlQy0VaCJDPiA9EOv8iMK1D9/IUxNaO', NULL, '2023-08-11 05:36:38', '2023-08-11 05:36:38');

-- --------------------------------------------------------

--
-- Structure de la table `user_addresses`
--

CREATE TABLE `user_addresses` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `address_1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `post_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `user_addresses`
--

INSERT INTO `user_addresses` (`id`, `user_id`, `address_1`, `address_2`, `state`, `city`, `street`, `post_code`, `created_at`, `updated_at`) VALUES
(1, 3, '45 East Fabien Lane', 'Corrupti suscipit c', 'Sunt corporis dolore', 'Doloremque sequi qui', 'Dignissimos nesciunt', 'Nostrud voluptate se', '2023-08-11 05:36:38', '2023-08-11 05:36:38'),
(2, 4, '45 East Hague Extension', 'Nisi voluptatem id a', 'Id rerum illo quia', 'Non non quis sit bea', 'Id atque nostrud occ', 'In voluptas quis odi', '2023-08-11 09:39:50', '2023-08-11 09:39:50');

-- --------------------------------------------------------

--
-- Structure de la table `user_payment_method`
--

CREATE TABLE `user_payment_method` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `payment_method_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `countries`
--
ALTER TABLE `countries`
  ADD PRIMARY KEY (`id`),
  ADD KEY `country_name` (`name`),
  ADD KEY `country_code` (`code`);

--
-- Index pour la table `currencies`
--
ALTER TABLE `currencies`
  ADD PRIMARY KEY (`id`),
  ADD KEY `currencies_country_id_foreign` (`country_id`),
  ADD KEY `curr_name` (`name`),
  ADD KEY `curr_code` (`code`);

--
-- Index pour la table `details`
--
ALTER TABLE `details`
  ADD PRIMARY KEY (`id`),
  ADD KEY `details_order_id_foreign` (`order_id`),
  ADD KEY `details_parcel_id_foreign` (`parcel_id`),
  ADD KEY `details_receiver_id_foreign` (`receiver_id`);

--
-- Index pour la table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Index pour la table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Index pour la table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Index pour la table `modules`
--
ALTER TABLE `modules`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modules_name_index` (`name`);

--
-- Index pour la table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `orders_user_id_foreign` (`user_id`),
  ADD KEY `orders_currency_foreign` (`currency`),
  ADD KEY `orders_payment_method_foreign` (`payment_method`),
  ADD KEY `orders_status_foreign` (`status`),
  ADD KEY `orders_reference_index` (`reference`);

--
-- Index pour la table `parcels`
--
ALTER TABLE `parcels`
  ADD PRIMARY KEY (`id`),
  ADD KEY `parcels_parcel_category_id_foreign` (`parcel_category_id`),
  ADD KEY `parcels_country_from_foreign` (`country_from`),
  ADD KEY `parcels_country_to_foreign` (`country_to`);

--
-- Index pour la table `parcel_categories`
--
ALTER TABLE `parcel_categories`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `parcel_prices`
--
ALTER TABLE `parcel_prices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `parcel_prices_parcel_category_id_foreign` (`parcel_category_id`),
  ADD KEY `parcel_prices_reseller_foreign` (`reseller`),
  ADD KEY `parcel_prices_country_from_foreign` (`country_from`),
  ADD KEY `parcel_prices_country_to_foreign` (`country_to`);

--
-- Index pour la table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Index pour la table `payment_methods`
--
ALTER TABLE `payment_methods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `payment_methods_name_index` (`name`);

--
-- Index pour la table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`);

--
-- Index pour la table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Index pour la table `receiver_details`
--
ALTER TABLE `receiver_details`
  ADD PRIMARY KEY (`id`),
  ADD KEY `receiver_details_country_foreign` (`country`);

--
-- Index pour la table `resellers`
--
ALTER TABLE `resellers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `resellers_name_index` (`name`);

--
-- Index pour la table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- Index pour la table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Index pour la table `setting_systems`
--
ALTER TABLE `setting_systems`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `statuses`
--
ALTER TABLE `statuses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `statuses_module_foreign` (`module`),
  ADD KEY `statuses_name_index` (`name`);

--
-- Index pour la table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_country_id_foreign` (`country_id`),
  ADD KEY `users_reseller_foreign` (`reseller`),
  ADD KEY `users_status_foreign` (`status`);

--
-- Index pour la table `user_addresses`
--
ALTER TABLE `user_addresses`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `user_payment_method`
--
ALTER TABLE `user_payment_method`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_payment_method_user_id_foreign` (`user_id`),
  ADD KEY `user_payment_method_payment_method_id_foreign` (`payment_method_id`);

--
-- AUTO_INCREMENT pour les tables déchargées
--

--
-- AUTO_INCREMENT pour la table `countries`
--
ALTER TABLE `countries`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT pour la table `currencies`
--
ALTER TABLE `currencies`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT pour la table `details`
--
ALTER TABLE `details`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT pour la table `modules`
--
ALTER TABLE `modules`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT pour la table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `parcels`
--
ALTER TABLE `parcels`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `parcel_categories`
--
ALTER TABLE `parcel_categories`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT pour la table `parcel_prices`
--
ALTER TABLE `parcel_prices`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=59;

--
-- AUTO_INCREMENT pour la table `payment_methods`
--
ALTER TABLE `payment_methods`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT pour la table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `receiver_details`
--
ALTER TABLE `receiver_details`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `resellers`
--
ALTER TABLE `resellers`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT pour la table `setting_systems`
--
ALTER TABLE `setting_systems`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `statuses`
--
ALTER TABLE `statuses`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT pour la table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `user_addresses`
--
ALTER TABLE `user_addresses`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT pour la table `user_payment_method`
--
ALTER TABLE `user_payment_method`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Contraintes pour les tables déchargées
--

--
-- Contraintes pour la table `currencies`
--
ALTER TABLE `currencies`
  ADD CONSTRAINT `currencies_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `details`
--
ALTER TABLE `details`
  ADD CONSTRAINT `details_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `details_parcel_id_foreign` FOREIGN KEY (`parcel_id`) REFERENCES `parcels` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `details_receiver_id_foreign` FOREIGN KEY (`receiver_id`) REFERENCES `receiver_details` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- Contraintes pour la table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Contraintes pour la table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_currency_foreign` FOREIGN KEY (`currency`) REFERENCES `currencies` (`code`) ON DELETE CASCADE,
  ADD CONSTRAINT `orders_payment_method_foreign` FOREIGN KEY (`payment_method`) REFERENCES `payment_methods` (`name`) ON DELETE CASCADE,
  ADD CONSTRAINT `orders_status_foreign` FOREIGN KEY (`status`) REFERENCES `statuses` (`name`) ON DELETE CASCADE,
  ADD CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Contraintes pour la table `parcels`
--
ALTER TABLE `parcels`
  ADD CONSTRAINT `parcels_country_from_foreign` FOREIGN KEY (`country_from`) REFERENCES `countries` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `parcels_country_to_foreign` FOREIGN KEY (`country_to`) REFERENCES `countries` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `parcels_parcel_category_id_foreign` FOREIGN KEY (`parcel_category_id`) REFERENCES `parcel_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `parcel_prices`
--
ALTER TABLE `parcel_prices`
  ADD CONSTRAINT `parcel_prices_country_from_foreign` FOREIGN KEY (`country_from`) REFERENCES `countries` (`code`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `parcel_prices_country_to_foreign` FOREIGN KEY (`country_to`) REFERENCES `countries` (`code`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `parcel_prices_parcel_category_id_foreign` FOREIGN KEY (`parcel_category_id`) REFERENCES `parcel_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `parcel_prices_reseller_foreign` FOREIGN KEY (`reseller`) REFERENCES `resellers` (`name`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `receiver_details`
--
ALTER TABLE `receiver_details`
  ADD CONSTRAINT `receiver_details_country_foreign` FOREIGN KEY (`country`) REFERENCES `countries` (`name`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Contraintes pour la table `statuses`
--
ALTER TABLE `statuses`
  ADD CONSTRAINT `statuses_module_foreign` FOREIGN KEY (`module`) REFERENCES `modules` (`name`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `users_reseller_foreign` FOREIGN KEY (`reseller`) REFERENCES `resellers` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `users_status_foreign` FOREIGN KEY (`status`) REFERENCES `statuses` (`name`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `user_payment_method`
--
ALTER TABLE `user_payment_method`
  ADD CONSTRAINT `user_payment_method_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_payment_method_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
