@extends('layouts.master-layouts')
{{-- page title --}}
@section('title')
    @lang('change_rate_list')
@endsection
@section('content')
    <x-breadcrumb-component title="change rate"></x-breadcrumb-component>
    @include('admin.includes.show-msg')
    <!-- users list start -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <x-tabs-setting-component curr="3"></x-tabs-setting-component>
                <div class="card-body border-bottom">
                    <div class="d-flex align-items-center">
                        <h5 class="mb-0 card-title flex-grow-1">@lang('change_rate_list')</h5>
                        <div class="flex-shrink-0">
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#add-change_rate">
                                @lang('add_new_change_rate')
                            </button>
                            @include('admin.setting_system.change_rate.create')
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- datatable start -->
                    <div class="row">
                        <div class="col-lg-12">
                            <ul class="list-group">
                                <li class="list-group-item">
                                    <div class="row">
                                        <div class="col-lg-3"><b>From change rate <sub>(code)</sub></b></div>
                                        <div class="col-lg-3"><b>To change rate <sub>(code)</sub></b></div>
                                        <div class="col-lg-3"><b>Rate</b></div>
                                        <div class="col-lg-3 text-center"><b>Action</b></div>
                                    </div>
                                </li>
                                @foreach ($change_rates as $item)
                                    @php
                                        $erID = $item->id;
                                    @endphp
                                    <li class="list-group-item">
                                        <div class="row">
                                            <div class="col-lg-3"><b>{{ $item->from_currency }}</b></div>
                                            <div class="col-lg-2">{{ $item->to_currency }}</div>
                                            <div class="col-lg-3">
                                                {{ $item->rate }}
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="d-flex align-items-center justify-content-center">
                                                    <ul class="list-unstyled hstack gap-1 mb-0">
                                                        <li data-bs-toggle="tooltip" data-bs-placement="top"
                                                            aria-label="Edit">
                                                            <button type="button" class="btn btn-sm btn-soft-info"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#edit-change_rate-{{ $item->id }}">
                                                                <i class="mdi mdi-pencil-outline"></i>
                                                            </button>
                                                            @include('admin.setting_system.change_rate.edit')
                                                        </li>
                                                        <li data-bs-toggle="tooltip" data-bs-placement="top"
                                                            aria-label="Delete">
                                                            <form
                                                                action="{{ route('admin.change-rate.destroy', ['change_rate' => $item->id]) }}"
                                                                method="post" class="deleteAll">
                                                                @csrf
                                                                @method('delete')
                                                                <button type="submit" class="btn btn-sm btn-soft-danger">
                                                                    <i class="mdi mdi-delete-outline"></i>
                                                                </button>
                                                            </form>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <!-- datatable ends -->
                </div>
                <div class="card-footer p-0 mb-0">
                    {{ $change_rates->links() }}
                </div>
            </div>
        </div>
        <!--end card-->
    </div>
@endsection
@section('script')
    <script src="{{ asset('build/libs/select2/select2.min.js') }}"></script>
    <script>
        $(".select2").select2();
    </script>
    @if (count($errors) > 0)
        <script>
            $(document).ready(function() {
                $("#add-change_rate").modal('show');
            });
        </script>
    @endif

    @if (session()->has('errID'))
        <script>
            $(document).ready(function() {
                $("#edit-change_rate-{{ session()->get('errID') }}").modal('show');
            });
        </script>
    @endif
    @include('admin.includes.sweet-alert')
@endsection
