@php
		$configData = Helper::appClasses();
		$color = ['primary', 'warning', 'success', 'danger'];
@endphp

@extends('layouts/layoutMaster')

@section('title', 'User')

@section('content')
		@include('admin.includes.show-msg')
		<h4 class="py-3 breadcrumb-wrapper mb-2">Users List</h4>
		<!-- Role cards -->
		<div class="row g-4">
				<div class="col-xl-12">
						<div class="card h-100">
								<div class="row h-100 bg-">
										<div class="col-sm-5">
												<div class="d-flex align-items-end h-100 justify-content-center mt-sm-0 mt-3">
														<img src="{{ asset('assets/img/illustrations/boy-with-laptop-' . $configData['style'] . '.png') }}"
																class="img-fluid" alt="Image" width="100" data-app-light-img="illustrations/boy-with-laptop-light.png"
																data-app-dark-img="illustrations/boy-with-laptop-dark.png">
												</div>
										</div>
										<div class="col-sm-7">
												<div class="card-body text-sm-end text-center ps-sm-0">
														<button data-bs-target="#add-user" data-bs-toggle="modal"
																class="btn btn-primary mb-3 text-nowrap add-new-user">Add New User</button>
														<p class="mb-0">Add user, if it does not exist</p>
												</div>
										</div>
								</div>
						</div>
				</div>
				<!-- Role Table -->
				<div class="col-md-12">
						<div class="card">
								<div class="table-responsive text-nowrap">
										<table class="table table-hover">
												<thead>
														<tr>
																<th>#</th>
																<th>Name</th>
																<th>Email</th>
																<th>Telephone</th>
																{{-- <th>Address</th> --}}
																<th>Reseller</th>
																<th>Role</th>
																<th>Status</th>
																<th>Actions</th>
														</tr>
												</thead>
												<tbody class="table-border-bottom-0">
														@forelse ($users as $item)
																<tr>
																		<th>{{ $loop->iteration }}</th>
																		<td>{{ Str::ucfirst($item->name) }}</td>
																		<td>{{ Str::ucfirst($item->email) }}</td>
																		<td>{{ Str::ucfirst($item->telephone) }}</td>
																		{{-- <td>{{ Str::ucfirst($item->address) }}</td> --}}
																		<td>
																				{{ $item?->reseller ? Str::ucfirst($item->reseller) : 'N\A' }}
																		</td>
																		<td>
																				@foreach ($item->roles->pluck('name') as $key => $role)
																						<span class="badge bg-label-{{ $color[$key] }}">
																								{{ Str::upper($role) }}
																						</span>
																				@endforeach
																		</td>
																		<td>
																				@switch($item->status)
																						@case('pending')
																								<span class="badge rounded-pill bg-warning">{{ Str::upper($item->status) }}</span>
																						@break

																						@case('active')
																								<span class="badge rounded-pill bg-success">{{ Str::upper($item->status) }}</span>
																						@break

																						@case('suspended')
																								<span class="badge rounded-pill bg-danger">{{ Str::upper($item->status) }}</span>
																						@break

																						@default
																								<span class="badge rounded-pill bg-secondary">{{ Str::upper($item->status) }}</span>
																				@endswitch
																		</td>
																		<td>
																				<div class="dropdown">
																						<button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
																								<i class="bx bx-dots-vertical-rounded"></i>
																						</button>
																						<div class="dropdown-menu">
																								<button data-bs-target="#edit-user-{{ $item->id }}" data-bs-toggle="modal"
																										class="dropdown-item">
																										<i class="bx bx-edit-alt me-1"></i> Edit
																								</button>
																								<button data-bs-target="#change-password-{{ $item->id }}" data-bs-toggle="modal"
																										class="dropdown-item">
																										<i class="bx bx-key me-1"></i> Modify password
																								</button>
																								<form action="{{ route('user.destroy', ['user' => $item]) }}" method="post">
																										@csrf
																										@method('delete')
																										<button type="submit" class="dropdown-item deleteAll" data-msg="user - {{ $item->name }}">
																												<i class="bx bx-trash me-1"></i> Delete
																										</button>
																								</form>
																						</div>
																				</div>
																		</td>
																</tr>
																@include('admin.user.edit', ['user' => $item])
																@include('admin.user.change_password', ['user' => $item])
																@empty
																		<tr>
																				<th>No record found.</th>
																		</tr>
																@endforelse
														</tbody>
												</table>
										</div>
								</div>
								<div class="card-footer">
										{{ $users->links() }}
								</div>
						</div>
				</div>
				@include('admin.user.create')
		@endsection
		@section('page-script')
				@if (count($errors) > 0)
						@dump($errors)
						<script>
								$(document).ready(function() {
										$("#add-user").modal('show');
								});
						</script>
				@endif

				@if (session()->has('err'))
						<script>
								$(document).ready(function() {
										$("#edit-user-" + {{ session()->get('err') }}).modal('show');
								});
						</script>
				@endif

				@if (session()->has('err_pwsd'))
						<script>
								$(document).ready(function() {
										$("#change-password-" + {{ session()->get('err_pwsd') }}).modal('show');
								});
						</script>
				@endif
		@endsection
