<?php
		$containerNav = $containerNav ?? 'container-fluid';
?>

<!-- Navbar -->
<nav class="layout-navbar navbar navbar-expand-xl align-items-center bg-navbar-theme" id="layout-navbar">
		<div class="<?php echo e($containerNav); ?>">

				<!--  Brand demo (display only for navbar-full and hide on below xl) -->
				<?php if(isset($navbarFull)): ?>
						<div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4">
								<a href="<?php echo e(url('/')); ?>" class="app-brand-link gap-2">
										<span class="app-brand-logo demo">
												<?php echo $__env->make('_partials.macros', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
										</span>
										<span class="app-brand-text demo menu-text fw-bold"><?php echo e(config('variables.templateName')); ?></span>
								</a>

								<?php if(isset($menuHorizontal)): ?>
										<!-- Display menu close icon only for horizontal-menu with navbar-full -->
										<a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-xl-none">
												<i class="bx bx-x bx-sm align-middle"></i>
										</a>
								<?php endif; ?>
						</div>
				<?php endif; ?>

				<!-- ! Not required for layout-without-menu -->
				<?php if(!isset($navbarHideToggle)): ?>
						<div
								class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0<?php echo e(isset($menuHorizontal) ? ' d-xl-none ' : ''); ?> <?php echo e(isset($contentNavbar) ? ' d-xl-none ' : ''); ?>">
								<a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
										<i class="bx bx-menu bx-sm"></i>
								</a>
						</div>
				<?php endif; ?>

				<div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">

						<?php if(!isset($menuHorizontal)): ?>
								<!-- Search -->
								<div class="navbar-nav align-items-center">
										<div class="nav-item navbar-search-wrapper mb-0">
												<a class="nav-item nav-link search-toggler px-0" href="javascript:void(0);">
														<i class="bx bx-search-alt bx-sm"></i>
														<span class="d-none d-md-inline-block text-muted">Search (Ctrl+/)</span>
												</a>
										</div>
								</div>
								<!-- /Search -->
						<?php endif; ?>

						<ul class="navbar-nav flex-row align-items-center ms-auto">
								<!-- Language -->
								<li class="nav-item dropdown-language dropdown me-2 me-xl-0">
										<a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
												<i class='fi fi-us fis rounded-circle fs-3  me-1'></i>
										</a>
										<ul class="dropdown-menu dropdown-menu-end">
												<li>
														<a class="dropdown-item" href="<?php echo e(url('lang/en')); ?>" data-language="en">
																<i class="fi fi-us fis rounded-circle fs-4 me-1"></i>
																<span class="align-middle">English</span>
														</a>
												</li>
												<li>
														<a class="dropdown-item" href="<?php echo e(url('lang/fr')); ?>" data-language="fr">
																<i class="fi fi-fr fis rounded-circle fs-4 me-1"></i>
																<span class="align-middle">French</span>
														</a>
												</li>
										</ul>
								</li>
								<!--/ Language -->
								<?php if(isset($menuHorizontal)): ?>
										<!-- Search -->
										<li class="nav-item navbar-search-wrapper me-2 me-xl-0">
												<a class="nav-item nav-link search-toggler" href="javascript:void(0);">
														<i class="bx bx-search bx-sm"></i>
												</a>
										</li>
										<!-- /Search -->
								<?php endif; ?>


								<!-- Style Switcher -->
								<li class="nav-item me-2 me-xl-0">
										<a class="nav-link style-switcher-toggle hide-arrow" href="javascript:void(0);">
												<i class='bx bx-sm'></i>
										</a>
								</li>
								<!--/ Style Switcher -->

								<!-- Quick links  -->
								
								<!-- Quick links -->

								<!-- Notification -->
								<li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-2">
										<a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown"
												data-bs-auto-close="outside" aria-expanded="false">
												<i class="bx bx-bell bx-sm"></i>
												<span class="badge bg-danger rounded-pill badge-notifications">5</span>
										</a>
										<ul class="dropdown-menu dropdown-menu-end py-0">
												<li class="dropdown-menu-header border-bottom">
														<div class="dropdown-header d-flex align-items-center py-3">
																<h5 class="text-body mb-0 me-auto">Notification</h5>
																<a href="javascript:void(0)" class="dropdown-notifications-all text-body" data-bs-toggle="tooltip"
																		data-bs-placement="top" title="Mark all as read"><i class="bx fs-4 bx-envelope-open"></i></a>
														</div>
												</li>
												<li class="dropdown-notifications-list scrollable-container">
														<ul class="list-group list-group-flush">
																<li class="list-group-item list-group-item-action dropdown-notifications-item">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<img src="<?php echo e(asset('assets/img/avatars/1.png')); ?>" alt class="w-px-40 h-auto rounded-circle">
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">Congratulation Lettie 🎉</h6>
																						<p class="mb-0">Won the monthly best seller gold badge</p>
																						<small class="text-muted">1h ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<span class="avatar-initial rounded-circle bg-label-danger">CF</span>
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">Charles Franklin</h6>
																						<p class="mb-0">Accepted your connection</p>
																						<small class="text-muted">12hr ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item marked-as-read">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<img src="<?php echo e(asset('assets/img/avatars/2.png')); ?>" alt class="w-px-40 h-auto rounded-circle">
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">New Message ✉️</h6>
																						<p class="mb-0">You have new message from Natalie</p>
																						<small class="text-muted">1h ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<span class="avatar-initial rounded-circle bg-label-success"><i class="bx bx-cart"></i></span>
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">Whoo! You have new order 🛒 </h6>
																						<p class="mb-0">ACME Inc. made new order $1,154</p>
																						<small class="text-muted">1 day ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item marked-as-read">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<img src="<?php echo e(asset('assets/img/avatars/9.png')); ?>" alt class="w-px-40 h-auto rounded-circle">
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">Application has been approved 🚀 </h6>
																						<p class="mb-0">Your ABC project application has been approved.</p>
																						<small class="text-muted">2 days ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item marked-as-read">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<span class="avatar-initial rounded-circle bg-label-success"><i
																												class="bx bx-pie-chart-alt"></i></span>
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">Monthly report is generated</h6>
																						<p class="mb-0">July monthly financial report is generated </p>
																						<small class="text-muted">3 days ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item marked-as-read">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<img src="<?php echo e(asset('assets/img/avatars/5.png')); ?>" alt class="w-px-40 h-auto rounded-circle">
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">Send connection request</h6>
																						<p class="mb-0">Peter sent you connection request</p>
																						<small class="text-muted">4 days ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<img src="<?php echo e(asset('assets/img/avatars/6.png')); ?>" alt class="w-px-40 h-auto rounded-circle">
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">New message from Jane</h6>
																						<p class="mb-0">Your have new message from Jane</p>
																						<small class="text-muted">5 days ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
																<li class="list-group-item list-group-item-action dropdown-notifications-item marked-as-read">
																		<div class="d-flex">
																				<div class="flex-shrink-0 me-3">
																						<div class="avatar">
																								<span class="avatar-initial rounded-circle bg-label-warning"><i
																												class="bx bx-error"></i></span>
																						</div>
																				</div>
																				<div class="flex-grow-1">
																						<h6 class="mb-1">CPU is running high</h6>
																						<p class="mb-0">CPU Utilization Percent is currently at 88.63%,</p>
																						<small class="text-muted">5 days ago</small>
																				</div>
																				<div class="flex-shrink-0 dropdown-notifications-actions">
																						<a href="javascript:void(0)" class="dropdown-notifications-read"><span
																										class="badge badge-dot"></span></a>
																						<a href="javascript:void(0)" class="dropdown-notifications-archive"><span
																										class="bx bx-x"></span></a>
																				</div>
																		</div>
																</li>
														</ul>
												</li>
												<li class="dropdown-menu-footer border-top">
														<a href="javascript:void(0);"
																class="dropdown-item d-flex justify-content-center text-primary p-2 h-px-40">
																View all notifications
														</a>
												</li>
										</ul>
								</li>
								<!--/ Notification -->

								<!-- User -->
								<li class="nav-item navbar-dropdown dropdown-user dropdown">
										<a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
												<div class="avatar avatar-online">
														<img src="<?php echo e(asset('assets/img/avatars/1.png')); ?>" alt class="rounded-circle">
												</div>
										</a>
										<ul class="dropdown-menu dropdown-menu-end">
												<li>
														<a class="dropdown-item"
																href="<?php echo e(Route::has('profile.show') ? route('profile.show') : url('pages/profile-user')); ?>">
																<div class="d-flex">
																		<div class="flex-shrink-0 me-3">
																				<div class="avatar avatar-online">
																						<img src="<?php echo e(asset('assets/img/avatars/1.png')); ?>" alt class="rounded-circle">
																				</div>
																		</div>
																		<div class="flex-grow-1">
																				<span class="fw-semibold d-block">
																						<?php if(Auth::check()): ?>
																								<?php echo e(Auth::user()->name); ?>

																						<?php else: ?>
																								John Doe
																						<?php endif; ?>
																				</span>
																				<small class="text-muted">Admin</small>
																		</div>
																</div>
														</a>
												</li>
												<li>
														<div class="dropdown-divider"></div>
												</li>
												<li>
														<a class="dropdown-item"
																href="<?php echo e(Route::has('profile.show') ? route('profile.show') : url('pages/profile-user')); ?>">
																<i class="bx bx-user me-2"></i>
																<span class="align-middle">My Profile</span>
														</a>
												</li>
												
												<li>
														<a class="dropdown-item" href="<?php echo e(url('app/invoice/list')); ?>">
																<i class="bx bx-credit-card me-2"></i>
																<span class="align-middle">Billing</span>
														</a>
												</li>
												

												
												<li>
														<div class="dropdown-divider"></div>
												</li>
												<li>
														<a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
																onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
																<i class='bx bx-power-off me-2'></i>
																<span class="align-middle">Logout</span>
														</a>
												</li>
												<form method="POST" id="logout-form" action="<?php echo e(route('logout')); ?>">
														<?php echo csrf_field(); ?>
												</form>
										</ul>
								</li>
								<!--/ User -->
						</ul>
				</div>

				<!-- Search Small Screens -->
				<div class="navbar-search-wrapper search-input-wrapper <?php echo e(isset($menuHorizontal) ? $containerNav : ''); ?> d-none">
						<input type="text"
								class="form-control search-input <?php echo e(isset($menuHorizontal) ? '' : $containerNav); ?> border-0"
								placeholder="Search..." aria-label="Search...">
						<i class="bx bx-x bx-sm search-toggler cursor-pointer"></i>
				</div>
		</div>
</nav>
<!-- / Navbar -->
<?php /**PATH C:\laragon\www\duma-expo\resources\views/layouts/sections/navbar/navbar.blade.php ENDPATH**/ ?>