<?php
		$configData = Helper::appClasses();
		$color = ['primary', 'warning', 'success', 'danger'];
?>



<?php $__env->startSection('title', 'User'); ?>

<?php $__env->startSection('content'); ?>
		<?php echo $__env->make('admin.includes.show-msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<h4 class="py-3 breadcrumb-wrapper mb-2">Users List</h4>
		<!-- Role cards -->
		<div class="row g-4">
				<div class="col-xl-12">
						<div class="card h-100">
								<div class="row h-100 bg-">
										<div class="col-sm-5">
												<div class="d-flex align-items-end h-100 justify-content-center mt-sm-0 mt-3">
														<img src="<?php echo e(asset('assets/img/illustrations/boy-with-laptop-' . $configData['style'] . '.png')); ?>"
																class="img-fluid" alt="Image" width="100" data-app-light-img="illustrations/boy-with-laptop-light.png"
																data-app-dark-img="illustrations/boy-with-laptop-dark.png">
												</div>
										</div>
										<div class="col-sm-7">
												<div class="card-body text-sm-end text-center ps-sm-0">
														<button data-bs-target="#add-user" data-bs-toggle="modal"
																class="btn btn-primary mb-3 text-nowrap add-new-user">Add New User</button>
														<p class="mb-0">Add user, if it does not exist</p>
												</div>
										</div>
								</div>
						</div>
				</div>
				<!-- Role Table -->
				<div class="col-md-12">
						<div class="card">
								<div class="table-responsive text-nowrap">
										<table class="table table-hover">
												<thead>
														<tr>
																<th>#</th>
																<th>Name</th>
																<th>Email</th>
																<th>Telephone</th>
																
																<th>Reseller</th>
																<th>Role</th>
																<th>Status</th>
																<th>Actions</th>
														</tr>
												</thead>
												<tbody class="table-border-bottom-0">
														<?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
																<tr>
																		<th><?php echo e($loop->iteration); ?></th>
																		<td><?php echo e(Str::ucfirst($item->name)); ?></td>
																		<td><?php echo e(Str::ucfirst($item->email)); ?></td>
																		<td><?php echo e(Str::ucfirst($item->telephone)); ?></td>
																		
																		<td>
																				<?php echo e($item?->reseller ? Str::ucfirst($item->reseller) : 'N\A'); ?>

																		</td>
																		<td>
																				<?php $__currentLoopData = $item->roles->pluck('name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																						<span class="badge bg-label-<?php echo e($color[$key]); ?>">
																								<?php echo e(Str::upper($role)); ?>

																						</span>
																				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
																		</td>
																		<td>
																				<?php switch($item->status):
																						case ('pending'): ?>
																								<span class="badge rounded-pill bg-warning"><?php echo e(Str::upper($item->status)); ?></span>
																						<?php break; ?>

																						<?php case ('active'): ?>
																								<span class="badge rounded-pill bg-success"><?php echo e(Str::upper($item->status)); ?></span>
																						<?php break; ?>

																						<?php case ('suspended'): ?>
																								<span class="badge rounded-pill bg-danger"><?php echo e(Str::upper($item->status)); ?></span>
																						<?php break; ?>

																						<?php default: ?>
																								<span class="badge rounded-pill bg-secondary"><?php echo e(Str::upper($item->status)); ?></span>
																				<?php endswitch; ?>
																		</td>
																		<td>
																				<div class="dropdown">
																						<button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
																								<i class="bx bx-dots-vertical-rounded"></i>
																						</button>
																						<div class="dropdown-menu">
																								<button data-bs-target="#edit-user-<?php echo e($item->id); ?>" data-bs-toggle="modal"
																										class="dropdown-item">
																										<i class="bx bx-edit-alt me-1"></i> Edit
																								</button>
																								<button data-bs-target="#change-password-<?php echo e($item->id); ?>" data-bs-toggle="modal"
																										class="dropdown-item">
																										<i class="bx bx-key me-1"></i> Modify password
																								</button>
																								<form action="<?php echo e(route('user.destroy', ['user' => $item])); ?>" method="post">
																										<?php echo csrf_field(); ?>
																										<?php echo method_field('delete'); ?>
																										<button type="submit" class="dropdown-item deleteAll" data-msg="user - <?php echo e($item->name); ?>">
																												<i class="bx bx-trash me-1"></i> Delete
																										</button>
																								</form>
																						</div>
																				</div>
																		</td>
																</tr>
																<?php echo $__env->make('admin.user.edit', ['user' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
																<?php echo $__env->make('admin.user.change_password', ['user' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
																		<tr>
																				<th>No record found.</th>
																		</tr>
																<?php endif; ?>
														</tbody>
												</table>
										</div>
								</div>
								<div class="card-footer">
										<?php echo e($users->links()); ?>

								</div>
						</div>
				</div>
				<?php echo $__env->make('admin.user.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<?php $__env->stopSection(); ?>
		<?php $__env->startSection('page-script'); ?>
				<?php if(count($errors) > 0): ?>
						<?php dump($errors); ?>
						<script>
								$(document).ready(function() {
										$("#add-user").modal('show');
								});
						</script>
				<?php endif; ?>

				<?php if(session()->has('err')): ?>
						<script>
								$(document).ready(function() {
										$("#edit-user-" + <?php echo e(session()->get('err')); ?>).modal('show');
								});
						</script>
				<?php endif; ?>

				<?php if(session()->has('err_pwsd')): ?>
						<script>
								$(document).ready(function() {
										$("#change-password-" + <?php echo e(session()->get('err_pwsd')); ?>).modal('show');
								});
						</script>
				<?php endif; ?>
		<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\duma-expo\resources\views/admin/user/index.blade.php ENDPATH**/ ?>