<?php

namespace App\Http\Controllers\Admin;

use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\classes\service\CurrencyService;
use App\Models\Country;

class CurrencyController extends Controller
{
  private CurrencyService $currencyService;

  public function __construct()
  {
    $this->currencyService = new CurrencyService();
  }
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    //
    $countries = Country::all();
    $currencies = $this->currencyService->Index($request);
    return view("admin.currency.index", compact("currencies", "countries"));
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
    // $countries = Country::all();

    // //dd($countries);

    // return view('admin.currency.c', compact('countries'));
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    $data = $this->currencyService->DataValidation($request, "post");
    if ($data->fails()) {
      return back()->withInput()->withErrors($data);
    }
    $country = $this->currencyService->Create($request);
    return redirect()->route("currency.index")->with("success", "Currency successfully created.");
  }

  /**
   * Display the specified resource.
   */
  public function show(Currency $currency)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Currency $currency)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, Currency $currency)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Currency $currency)
  {
    //
  }
}
