<?php

namespace App\classes\service;

use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator as ValidatorReturn;

class ResellerService
{
  public function Index(Request $request)
  {
    $resellers =  Reseller::paginate(15);
    return $resellers;
  }
  public function Create(Request $request)
  {
    $name = trim(strtolower(htmlspecialchars($request->name)));
    return Reseller::create(["name" => $name]);
  }
  public function Update(Request $request, Reseller $reseller): Reseller
  {
    $name = trim(strtolower(htmlspecialchars($request->name)));
    $reseller->update(["name" => $name]);
    return $reseller;
  }

  public function Delete(Reseller $reseller): bool
  {
    return $reseller->delete();
  }
  /**
   * Validation
   *
   * @param  Request $request
   * @param  string $method
   * @param  Reseller|bool $reseller
   * @return ValidatorReturn|null
   */
  public function DataValidation(Request $request, String $method, Reseller|bool $reseller = null): ValidatorReturn|null
  {
    switch (strtolower($method)) {
      case 'post':
        return Validator::make($request->all(), [
          "name" => ["required", "unique:resellers,name"]
        ]);
      case 'patch':
        return Validator::make($request->all(), [
          "name" => ["required", Rule::unique("resellers", "name")->ignore($reseller->id)]
        ]);
      default:
        return null;
    }
  }
}
