<div class="modal fade" id="add-corporate" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-corporate">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="corporate-title">Add New corporate</h3>
								</div>
								<form action="{{ route('corporate.store') }}" method="POST" class="row g-3">
										@csrf
										<div class="col-12 mb-0">
												<label for="user" class="form-label">User</label>
												<select id="user" class="select2 form-select form-select-lg @error('user_id') is-invalid @enderror"
														data-allow-clear="true" name="user_id">
														<option value="">Select user</option>
														@foreach ($users as $user)
																<option value="{{ $user->id }}" @selected((int) old('user_id') === $user->id)>
																		{{ $user->name . ' (' . $user->email . ')' }}
																</option>
														@endforeach
												</select>
												@error('user_id')
														<div class="invalid-feedback d-block">{{ $errors->first('user_id') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="name">Corporate name</label>
												<input type="text" id="name" name="name" class="form-control @error('name') is-invalid @enderror"
														placeholder="Enter a corporate name" value="{{ old('name') }}" />
												@error('name')
														<div class=" invalid-feedback">{{ $errors->first('name') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="address">Address</label>
												<input type="text" id="address" name="address"
														class="form-control @error('address') is-invalid @enderror" placeholder="Enter a Address"
														value="{{ old('address') }}" />
												@error('address')
														<div class=" invalid-feedback">{{ $errors->first('address') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="rate">Rate</label>
												<input type="number" id="rate" name="rate" class="form-control @error('rate') is-invalid @enderror"
														placeholder="Enter a Rate" value="{{ old('rate') }}" />
												@error('rate')
														<div class=" invalid-feedback">{{ $errors->first('rate') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Save</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
