<div class="modal fade" id="edit-corporate-{{ $corporate->id }}" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-corporate">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="corporate-title">Edit corporate - {{ Str::ucfirst($corporate->name) }}</h3>
								</div>
								<form action="{{ route('corporate.update', ['corporate' => $corporate]) }}" method="POST" class="row g-3">
										@csrf
										@method('patch')
										@php
												$err = 'err_' . $corporate->id;
										@endphp
										<div class="col-12 mb-2">
												<label for="user" class="form-label">User</label>
												<select id="user"
														class="select2 form-select form-select-lg @error('user_id', $err) is-invalid @enderror"
														data-allow-clear="true" name="user_id">
														<option value="">Select user</option>
														@foreach ($users as $user)
																<option value="{{ $user->id }}" @selected((int) old('user_id') === $user->id) @selected($corporate->user_id === $user->id)>
																		{{ $user->name . ' (' . $user->email . ')' }}
																</option>
														@endforeach
												</select>
												@error('user_id', $err)
														<div class="invalid-feedback d-block">{{ $errors->$err->first('user_id') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-2">
												<label class="form-label" for="name">Corporate name</label>
												<input type="text" id="name" name="name"
														class="form-control @error('name', $err) is-invalid @enderror" placeholder="Enter a corporate name"
														value="{{ old('name') ?? $corporate->name }}" />
												@error('name', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('name') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-2">
												<label class="form-label" for="address">Address</label>
												<input type="text" id="address" name="address"
														class="form-control @error('address', $err) is-invalid @enderror" placeholder="Enter a Address"
														value="{{ old('address') ?? $corporate->address }}" />
												@error('address', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('address') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-2">
												<label class="form-label" for="rate">Rate</label>
												<input type="number" id="rate" name="rate"
														class="form-control @error('rate', $err) is-invalid @enderror" placeholder="Enter a Rate"
														value="{{ old('rate') ?? $corporate->rate }}" />
												@error('rate', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('rate') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center mt-4">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
