<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('country_id');
            $table->string('reseller')->nullable();
            $table->string('name');
            $table->string('email')->unique();
            $table->string("telephone");
            $table->timestamp('email_verified_at')->nullable();
            $table->string("status");
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();

            $table->foreign("country_id")->references("id")->on("countries")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("reseller")->references("name")->on("resellers")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("status")->references("name")->on("statuses")->cascadeOnUpdate()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
