<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receiver_details', function (Blueprint $table) {
            $table->id();
            $table->string('country');
            $table->string('name');
            $table->string('email');
            $table->string("telephone");
            $table->string("address_1");
            $table->string("address_2");
            $table->string("city");
            $table->string("street")->nullable();
            $table->string("post_code");
            $table->timestamps();

            $table->foreign("country")->references("name")->on("countries")->cascadeOnUpdate()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receiver_details');
    }
};
