<div class="modal fade" id="edit-partner-{{ $partner->id }}" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-partner">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="partner-title">Edit partner - {{ Str::ucfirst($partner->partner_name) }}</h3>
								</div>
								<form action="{{ route('partner.update', ['partner' => $partner]) }}" method="POST" class="row g-3">
										@csrf
										@method('patch')

										@php
												$err = 'err_' . $partner->id;
										@endphp
										<div class="col-12 mb-0">
												<label for="user{{ $err }}" class="form-label">User</label>
												<div class="position-relative">
														<select id="user{{ $err }}"
																class="select2 form-select form-select-lg @error('user_id', $err) is-invalid @enderror" name="user_id">
																<option value="">Select user</option>
																@foreach ($users as $user)
																		<option value="{{ $user->id }}" @selected((int) old('user_id') === $user->id)@selected($partner->user_id === $user->id)>
																				{{ $user->name . ' (' . $user->email . ')' }}
																		</option>
																@endforeach
														</select>
												</div>
												@error('user_id', $err)
														<div class="invalid-feedback d-block">{{ $errors->$err->first('user_id') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="name{{ $err }}">Partner name</label>
												<input type="text" id="name{{ $err }}" name="partner_name"
														class="form-control @error('partner_name', $err) is-invalid @enderror" placeholder="Enter a partner name"
														value="{{ old('partner_name') ?? $partner->partner_name }}" />
												@error('partner_name', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('partner_name') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="name{{ $err }}">App secret</label>
												<input type="text" id="name{{ $err }}" name="app_secret"
														class="form-control @error('app_secret', $err) is-invalid @enderror" placeholder="Enter a App secret"
														value="{{ old('app_secret') ?? $partner->app_secret }}" />
												@error('app_secret', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('app_secret') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="name">App ID</label>
												<input type="text" id="name" name="app_id"
														class="form-control @error('app_id', $err) is-invalid @enderror" placeholder="Enter a App ID"
														value="{{ old('app_id') ?? $partner->app_id }}" />
												@error('app_id', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('app_id') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="name{{ $err }}">Callback URL</label>
												<input type="url" id="name{{ $err }}" name="callback_url"
														class="form-control @error('callback_url', $err) is-invalid @enderror" placeholder="Enter a Callback URL"
														value="{{ old('callback_url') ?? $partner->callback_url }}" />
												@error('callback_url', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('callback_url') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-3">
												<label class="form-label" for="status{{ $err }}">Status</label>
												<select id="status{{ $err }}" name="status"
														class="form-control @error('status', $err) is-invalid @enderror">
														<option value="">Select status</option>
														@foreach ($status as $st)
																<option value="{{ $st }}" @selected(old("status") === $st)@selected($partner->status === $st)>{{ Str::upper($st) }}</option>
														@endforeach
												</select>
												@error('status', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('status') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
